/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.compile;

import com.google.common.collect.ImmutableList;
import dev.engine_room.flywheel.api.instance.InstanceType;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.backend.compile.ContextShader;
import dev.engine_room.flywheel.backend.compile.OitPrograms;
import dev.engine_room.flywheel.backend.compile.PipelineCompiler;
import dev.engine_room.flywheel.backend.compile.Pipelines;
import dev.engine_room.flywheel.backend.compile.component.InstanceStructComponent;
import dev.engine_room.flywheel.backend.compile.component.SsboInstanceComponent;
import dev.engine_room.flywheel.backend.compile.core.CompilationHarness;
import dev.engine_room.flywheel.backend.compile.core.Compile;
import dev.engine_room.flywheel.backend.engine.uniform.Uniforms;
import dev.engine_room.flywheel.backend.gl.GlCompat;
import dev.engine_room.flywheel.backend.gl.shader.GlProgram;
import dev.engine_room.flywheel.backend.gl.shader.ShaderType;
import dev.engine_room.flywheel.backend.glsl.GlslVersion;
import dev.engine_room.flywheel.backend.glsl.ShaderSources;
import dev.engine_room.flywheel.backend.glsl.SourceComponent;
import dev.engine_room.flywheel.backend.util.AtomicReferenceCounted;
import dev.engine_room.flywheel.lib.util.ResourceUtil;
import java.util.List;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class IndirectPrograms
extends AtomicReferenceCounted {
    private static final class_2960 CULL_SHADER_API_IMPL = ResourceUtil.rl("internal/indirect/cull_api_impl.glsl");
    private static final class_2960 CULL_SHADER_MAIN = ResourceUtil.rl("internal/indirect/cull.glsl");
    private static final class_2960 APPLY_SHADER_MAIN = ResourceUtil.rl("internal/indirect/apply.glsl");
    private static final class_2960 SCATTER_SHADER_MAIN = ResourceUtil.rl("internal/indirect/scatter.glsl");
    private static final class_2960 DOWNSAMPLE_FIRST = ResourceUtil.rl("internal/indirect/downsample_first.glsl");
    private static final class_2960 DOWNSAMPLE_SECOND = ResourceUtil.rl("internal/indirect/downsample_second.glsl");
    private static final Compile<InstanceType<?>> CULL = new Compile();
    private static final Compile<class_2960> UTIL = new Compile();
    private static final List<String> EXTENSIONS = IndirectPrograms.getExtensions(GlCompat.MAX_GLSL_VERSION);
    private static final List<String> COMPUTE_EXTENSIONS = IndirectPrograms.getComputeExtensions(GlCompat.MAX_GLSL_VERSION);
    @Nullable
    private static IndirectPrograms instance;
    private final PipelineCompiler pipeline;
    private final CompilationHarness<InstanceType<?>> culling;
    private final CompilationHarness<class_2960> utils;
    private final OitPrograms oitPrograms;

    private IndirectPrograms(PipelineCompiler pipeline, CompilationHarness<InstanceType<?>> culling, CompilationHarness<class_2960> utils, OitPrograms oitPrograms) {
        this.pipeline = pipeline;
        this.culling = culling;
        this.utils = utils;
        this.oitPrograms = oitPrograms;
    }

    private static List<String> getExtensions(GlslVersion glslVersion) {
        ImmutableList.Builder extensions = ImmutableList.builder();
        if (glslVersion.compareTo(GlslVersion.V400) < 0) {
            extensions.add((Object)"GL_ARB_gpu_shader5");
        }
        if (glslVersion.compareTo(GlslVersion.V420) < 0) {
            extensions.add((Object)"GL_ARB_shading_language_420pack");
            extensions.add((Object)"GL_ARB_shader_image_load_store");
        }
        if (glslVersion.compareTo(GlslVersion.V430) < 0) {
            extensions.add((Object)"GL_ARB_shader_storage_buffer_object");
            extensions.add((Object)"GL_ARB_shader_image_size");
        }
        if (glslVersion.compareTo(GlslVersion.V460) < 0) {
            extensions.add((Object)"GL_ARB_shader_draw_parameters");
        }
        return extensions.build();
    }

    private static List<String> getComputeExtensions(GlslVersion glslVersion) {
        ImmutableList.Builder extensions = ImmutableList.builder();
        extensions.addAll(EXTENSIONS);
        if (glslVersion.compareTo(GlslVersion.V430) < 0) {
            extensions.add((Object)"GL_ARB_compute_shader");
        }
        return extensions.build();
    }

    static void reload(ShaderSources sources, List<SourceComponent> vertexComponents, List<SourceComponent> fragmentComponents) {
        if (!GlCompat.SUPPORTS_INDIRECT) {
            return;
        }
        PipelineCompiler pipelineCompiler = PipelineCompiler.create(sources, Pipelines.INDIRECT, vertexComponents, fragmentComponents, EXTENSIONS);
        CompilationHarness<InstanceType<?>> cullingCompiler = IndirectPrograms.createCullingCompiler(sources);
        CompilationHarness<class_2960> utilCompiler = IndirectPrograms.createUtilCompiler(sources);
        OitPrograms fullscreenCompiler = OitPrograms.createFullscreenCompiler(sources);
        IndirectPrograms newInstance = new IndirectPrograms(pipelineCompiler, cullingCompiler, utilCompiler, fullscreenCompiler);
        IndirectPrograms.setInstance(newInstance);
    }

    private static CompilationHarness<InstanceType<?>> createCullingCompiler(ShaderSources sources) {
        return CULL.program().link(CULL.shader(GlCompat.MAX_GLSL_VERSION, ShaderType.COMPUTE).nameMapper(instanceType -> "culling/" + ResourceUtil.toDebugFileNameNoExtension(instanceType.cullShader())).requireExtensions(COMPUTE_EXTENSIONS).define("_FLW_SUBGROUP_SIZE", GlCompat.SUBGROUP_SIZE).withResource(CULL_SHADER_API_IMPL).withComponent(InstanceStructComponent::new).withResource(InstanceType::cullShader).withComponent(SsboInstanceComponent::new).withResource(CULL_SHADER_MAIN)).postLink((key, program) -> Uniforms.setUniformBlockBindings(program)).harness("culling", sources);
    }

    private static CompilationHarness<class_2960> createUtilCompiler(ShaderSources sources) {
        return UTIL.program().link(UTIL.shader(GlCompat.MAX_GLSL_VERSION, ShaderType.COMPUTE).nameMapper(resourceLocation -> "utilities/" + ResourceUtil.toDebugFileNameNoExtension(resourceLocation)).requireExtensions(COMPUTE_EXTENSIONS).define("_FLW_SUBGROUP_SIZE", GlCompat.SUBGROUP_SIZE).withResource(s -> s)).harness("utilities", sources);
    }

    static void setInstance(@Nullable IndirectPrograms newInstance) {
        if (instance != null) {
            instance.release();
        }
        if (newInstance != null) {
            newInstance.acquire();
        }
        instance = newInstance;
    }

    @Nullable
    public static IndirectPrograms get() {
        return instance;
    }

    public static boolean allLoaded() {
        return instance != null;
    }

    public static void kill() {
        IndirectPrograms.setInstance(null);
    }

    public GlProgram getIndirectProgram(InstanceType<?> instanceType, ContextShader contextShader, Material material, PipelineCompiler.OitMode oit) {
        return this.pipeline.get(instanceType, contextShader, material, oit);
    }

    public GlProgram getCullingProgram(InstanceType<?> instanceType) {
        return this.culling.get(instanceType);
    }

    public GlProgram getApplyProgram() {
        return this.utils.get(APPLY_SHADER_MAIN);
    }

    public GlProgram getScatterProgram() {
        return this.utils.get(SCATTER_SHADER_MAIN);
    }

    public GlProgram getDownsampleFirstProgram() {
        return this.utils.get(DOWNSAMPLE_FIRST);
    }

    public GlProgram getDownsampleSecondProgram() {
        return this.utils.get(DOWNSAMPLE_SECOND);
    }

    public OitPrograms oitPrograms() {
        return this.oitPrograms;
    }

    @Override
    protected void _delete() {
        this.pipeline.delete();
        this.culling.delete();
        this.utils.delete();
        this.oitPrograms.delete();
    }
}

